define([
    'underscore',
    'backbone',
    'modules/new-appointment-request/resources/common/pac-team/collection',
    'modules/new-appointment-request/tests/helpers/general-helper',
], function(_, Backbone, Collection, helper) {
    'use strict';

    describe('Pac Team Collection', function() {

        describe('With Data', function() {
            var data;
            var collection;


            beforeEach(function() {
                helper.userSpy();
                data = helper.mockPacTeamData();
                collection = new Collection(data);
            });

            it('generates the correct url', function() {
                var expectedUrl = 'base-url/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/523/patient/ICN/testpatient/pact-team';
                var url = collection.getUrl('523');

                expect(url).toBe(expectedUrl);
            });

            it('returns true when the pac team is at the given facility', function() {
                var id = data[0].facilityId;
                expect(collection.hasPacTeamAtFacility(id)).toBeTruthy();
            });

            it('returns false when the pac team is not at the given facility', function() {
                var id = '!@#';
                expect(collection.hasPacTeamAtFacility(id)).toBeFalsy();
            });

            it('finds the primary providers', function() {
                var primaryProviders = collection.getPrimaryProviderList();
                expect(primaryProviders.length).toBe(2);
                expect(primaryProviders[0].get('staffName')).toBe(data[0].staffName);
                expect(primaryProviders[1].get('staffName')).toBe(data[1].staffName);
            });
        });
    });
});
